//Note: Details of scilab software version and OS version used:
//Tested on OS: Ubuntu 14.04 LTS, 64 bit
//Scilab version: 5.5.0 (Tested on 64 bit version)
//Program Title: Classless Addressing: To determine First address,Last address and Number of addresses in the block from any given classless address.

clear ;
clc ;
ip1 =input('Enter the 1st part of ip : ')
ip2 =input('Enter the 2nd part of ip : ')
ip3 =input('Enter the 3rd part of ip : ')
ip4 =input('Enter the 4th part of ip : ')
n =8;
a3 = dec2bin (ip1 , n ) ;
a2 = dec2bin (ip2 , n ) ;
a1 = dec2bin (ip3 , n ) ;
a0 = dec2bin (ip4 , n ) ;

mask =input('Enter the prefix length/ CIDR :');

num_of_zeros =32 - mask ; 
a = a3 + a2 + a1 + a0 ;
p1 = strsplit (a , mask ) ;
p = p1 (1) ;
for i = 1: num_of_zeros
    p=p+ ' 0 ' ; 
end
b = strsplit (p ,[8 16 24 ]); 
b3 = bin2dec ( b (1) ) ;
b2 = bin2dec ( b (2) ) ;
b1 = bin2dec ( b (3) ) ;
b0 = bin2dec ( b (4) ) ;

printf ( "\n a)Dotted Decimal notation of first address :− %d . %d . %d . %d / %d" ,b3 , b2 , b1 , b0 ,mask) ;

num_of_ones =32 - mask ; 
a = a3 + a2 + a1 + a0 ;
p1 = strsplit (a , mask ) ; 
p = p1 (1) ;
for i = 1: num_of_ones
    p=p+ ' 1 ' ;
end
b = strsplit (p ,[8 16 24 ]); 
b3 = bin2dec ( b (1) ) ;
b2 = bin2dec ( b (2) ) ;
b1 = bin2dec ( b (3) ) ;
b0 = bin2dec ( b (4) ) ;

printf ( "\n b)Dotted Decimal notation of last address  :− %d . %d . %d . %d / %d" ,b3 , b2 , b1 , b0 ,mask) ;

num_of_addresses = 2^(32-mask); 
printf ( "\n c) The number addresses is %d . " , num_of_addresses ) ;


////INPUT
//Enter the 1st part of ip : 167
//Enter the 2nd part of ip : 199
//Enter the 3rd part of ip : 170
//Enter the 4th part of ip : 82
//Enter the prefix length/ CIDR :27
//
//OUTPUT
//
//a)Dotted Decimal notation of first address :− 167 . 199 . 170 . 64 / 27
//b)Dotted Decimal notation of last address :− 167 . 199 . 170 . 95 / 27
//c) The number addresses is 32 .
